$(document).on("click", ".aggiungi_riga_foglioparticella", function(){
    var numero_fogli_prev = $("#fogli_aggiuntivi").attr("data-numerofogli")*1;
    var numero_fogli_now = numero_fogli_prev + 1;
    var riga_foglio = crea_riga_foglioparticelle(numero_fogli_now);
    $("#fogli_aggiuntivi").append(riga_foglio);
    $("#fogli_aggiuntivi").attr("data-numerofogli", numero_fogli_now);
});

$(document).on("click", ".rimuovi-riga-foglioparticella", function(){
    var num_riga = $(this).attr("data-numfoglio");
    $("#riga-foglio-particelle-"+num_riga).remove();
    var numero_fogli_prev = $("#fogli_aggiuntivi").attr("data-numerofogli")*1;
    var numero_fogli_now = numero_fogli_prev - 1;
    $("#fogli_aggiuntivi").attr("data-numerofogli", numero_fogli_now);
    ricrea_indici_righe_foglioparticelle(numero_fogli_now);
});

function crea_riga_foglioparticelle(numero_riga){
    var riga = `<div class="row" id="riga-foglio-particelle-${numero_riga}">
                    <div class="col-5 mb-2">
                        <label class="form-label" for="foglio_${numero_riga}">Foglio <span class="text-red">*</span></label>
                        <input type="text" 
                            class="form-control" 
                            name="foglio_${numero_riga}"
                            id="foglio_${numero_riga}" 
                            placeholder="Inserisci il foglio presente sui dati catastali" 
                            required 
                        />
                        <div class="" id="errore_foglio_${numero_riga}"></div>
                    </div>
                    <div class="col-6 mb-2">
                        <label class="form-label" for="particella_${numero_riga}">Particelle <span class="text-red">*</span></label>
                        <input type="text" 
                            class="form-control" 
                            name="particelle_${numero_riga}"
                            id="particelle_${numero_riga}" 
                            placeholder="Inserisci la/le particella/e presenti sui dati catastali" 
                            required 
                        />
                        <div class="" id="errore_particella_${numero_riga}"></div>
                    </div>
                    <div class="col-1 mb-2">
                        <p class="rimuovi-riga-foglioparticella" data-numfoglio="${numero_riga}" style="margin-top:2.4rem;"><span style="background-color:red;padding:0.3rem;border-radius:20%;"><i class="bi bi-trash3-fill" style="color:white;"></i></span></p>
                    </div>
                </div>`;
    return riga;
}

function ricrea_indici_righe_foglioparticelle(row){
    var rows = $("div[id^=riga-foglio-particelle-]");
    var counter = 1;
    rows.each(function(){
        var id = $(this).attr("id");
        if(id.substring(0, 23) == "riga-foglio-particelle-"){
            $(this).attr("id", "riga-foglio-particelle-"+counter);
            $(this).find(".rimuovi-riga-foglioparticella").attr("data-numfoglio", counter);
            $(this).find(".form-label").attr("for", "foglio_"+counter);
            $(this).find("div[id^=foglio_]").attr("id", "foglio_"+counter);
            $(this).find("div[id^=foglio_]").attr("name", "foglio_"+counter);
            $(this).find("div[id^=particelle_]").attr("id", "particelle_"+counter);
            $(this).find("div[id^=particelle_]").attr("name", "particelle_"+counter);
            $(this).find("div[id^=errore_foglio_]").attr("id", "errore_foglio_"+counter);
            $(this).find("div[id^=errore_particella_]").attr("id", "errore_particella_"+counter);
            if(counter == row){
                return;
            }
        }
        counter++;
    })
}